




/**********************************************************************************************
 *                                                                                            *
 *                                                                                            *
 * Ex3.      :   Sent Command Control ON/OFF 7-Segment (RL)                                   *
 *                                                                                            *
 *                                                                                            *
 **********************************************************************************************
 *                                                                                            *
 * Target MCU     : AT89C51RE2 (CP-JR51RE2 V1.0)                                              *
 * Editor         : uvision3 3.62c                                                            *       
 * Compiler       : Keil C51 (V9.51)                                                          *
 * Create By      : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                                      *
 * Last Update    : 15/October/2014                                                           *
 *															                                  *
 * Port Interface : # MCU-89C51RE2 #                 # Module ET-REMOTE Distance #            *
 *                  --------------                       --------------------                 *
 * UART0(RS232#1) :    P3.0(RX0)        Connect            Tx(RS232 PORT)                     *
 *                     P3.1(TX0)        Connect            Rx(RS232 PORT)                     *
 *                     GND              Connect            GND                                *																							  *
 *                                                         Set JP-TTL/RS232 to RS232          *
 *       Baud Rate = 57600 at Clock 18.432 Mhz             Set JP-BR (57600)                  *
 *                                                         Disable Filter                     *
 *                                                                                            *
 *   Operation    :  Control 7-Segment on Module ON/OFF Every  2 Sec                          *                                                          
 *                                                                                            *
 **********************************************************************************************/
  						
#include <at89c51xd2.h>
#include <stdio.h>
 
 unsigned int cnt =0                  ;  //valiable delay Counter timer0
 
//-----------Initial Funtion -------------

void UART0_Init(void)                 ;
void Timer0_Init(void)                ;

//---------- Function Check echo Command ---------

 void Check_Echo_Cmm(void) ;

//---------- Delay -------------
void delay_ms(unsigned int count)     ;

/********************************************
 **             Function Delay(ms)         **
 ********************************************/

//--------- delay ms ----------
void delay_ms(unsigned int count)          
 {
   	
    TR0 = 1        ;   //On Timer0
    ET0 = 1        ;   //Enable INT. Timer0
    cnt = 0        ;   //Start counter delay 	  

    while(cnt<count){;}

    TR0 = 0        ;	//off Timer0
    ET0 = 0        ;	//Disable INT. Timer0
 }


/***************************************************************
 **                                                           **
 **      Interrupt Service Timer0 (Interrupt every 1 ms)      **
 **                                                           **
 ***************************************************************/

//------- Interrupt Service Timer0 every 1 ms ------

 void TM0_Mod1() interrupt 1 
 {
 
  TF0  = 0         ; //Clear int. flag 
  TH0  = 0xF4      ; //Up date 16bit Reload Timer0
  TL0  = 0x00      ; //0xF400 = 1 ms 

  cnt = cnt+1      ; //Counter for Cursor blink

 }


//-------------- Recive Echo Command ----------------

void Check_Echo_Cmm(void)
 {
 
   unsigned char ch ;  
   
     do
      {
        while(RI==0){;}                   //Check Flag Rx if RI =1 Have data
        ch = SBUF 				        ; //Read data Start Byte
    	RI = 0                          ; //Clear Flag Rx

      }while(ch != '#')                 ; //Check Byte Start of Echo cmm('#')
     
	 do
	  {
		 while(RI==0){;}                ; //Check Flag Rx if RI =1 Have data
         ch = SBUF                      ; //Read Data End Byte
		 RI = 0                         ; //Clear Flag Rx
      }while(ch != 0x0D)                ; //Check Byte End of Echo cmm(0x0D)
  
   
 }

/********************************************************
 **                                                    **
 **                        MAIN                        **   
 **                                                    **
 ********************************************************/


void main (void) 
  {
     unsigned char enter = 0x0D ;
       
     CKCON0 = 0x01            ;  // div 6 clk mode  X2=1
     AUXR   = 0x10            ;  //Set XRAM = 1792 Byte

	 Timer0_Init()            ;   
	 UART0_Init()             ;

     delay_ms(500)            ;  //Wait Module ET-Remote Distance Ready when Power On
    
//----------------- Start Sent Command Read Distance --------------

    while(1) 
    {    
      //----------------- Start Sent Command Control ON/OFF 7-Segment On Module --------------

      //################---- Sent Command RL ----#################
	 	 
	  TI = 1                           ;   //Set Flag TI=1 for Start sent data
      printf("*RL=%c",enter)           ;   //Sent Command ON/OFF 7-Segment(Command Control 7-Seg fomat Toggle)       
	  while(TI == 0){;}	                   //Check Flag TI=1 Sent data Ready Exit loop 
      TI = 0                           ;   //Clear Flag TI 
     
	  Check_Echo_Cmm()                 ;   //Wait Echo Command for Sent Next Command	   
      delay_ms(2000)                   ;   //delay 2 Second

    }

  }



 /**********************************************************
  **                                                      **  
  **                       Sub-Program                    ** 
  **                                                      **
  **********************************************************/

 /********************************************
  *              Initial UART0               *
  ********************************************/

 void UART0_Init(void)
  {
   	//---------initial Uart0 ------------

   BDRCON |= 0x1C  ;  // Select Internal Baud-Rate,enable,0x1E=Fast //0x1C=No fast 	 
   SCON    = 0x50  ;  // Serial Mode1:8bit Uart,enable serial ,Clear Flag Rx/Tx 	   
   ES      = 0     ;  //Disable Serial Uart  Interrupt    

   BRL     = 0xEC  ;  // Baud Rate 57600  ,9600 = 0x88
   PCON   |= 0x80  ;  // Set SMOD1=1 :Double BR  
   BDRCON |= 0x02  ;  // Set SPD  =1 :Fast BR   
 
   EA      = 1     ;  //Enable global Interrupt  
   
  
  }


 /********************************************
  *              Initial Timer0               *
  ********************************************/
 
 void Timer0_Init(void)
 {		
  //------- Initial Timer0 Control Cursor ---------

  TH0	= 0xF4   ;	//Start Interrupt every 1 ms
  TL0   = 0x00   ;
  	 
  TMOD |= 0x01   ; //Use Timer0 Mode1 16-bit																							    
   ET0  = 0	     ; //Disable Timer0 Interrupt 
   TR0  = 0      ; //Set TCON Reg. Off Timer0
 }						   


